//
//  CRSceneItemVisual.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/23/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"

//////////////////////////////////////////////////////////////////////
// Scene item
//////////////////////////////////////////////////////////////////////
@interface CRSceneItemVisual : CRImageProcessor<CREditing, CRUndoable, CRInplaceEditing>
{
}

// Init
- (id)init;
- (id)initNoDeferred;
- (id)initClean;

// CREditing
- (BOOL)providesView;
- (Class)viewControllerClass;
- (NSViewController *)viewController;

// CRInplaceEditing
- (NSUInteger)defaultEditor;
- (NSArray *)inplaceEditors;
- (CGRect)workingRect;			// inplace editor helper
- (CGRect)safeRect;				// inplace editor helper

//////////////////////////////////////////////////////////////////////
#pragma mark Appearance

// All appearance methods are class-based, class implementation allows to build
// groups of icons, titles and descriptions without building heavy scene objects themselves
+ (NSImage *)thumbnail;
+ (NSString *)title;
+ (NSString *)fullDescription;
+ (NSString *)helpTopic;

@end